SpawnModel(model)
{
    if(IsSubStr(model,"com_plasticcase_"))
        clip  = level.airDropCrateCollision;
    model = SpawnScriptModel(self.origin,model,undefined,undefined,clip);
    
    self SetOrigin(self.origin+(0,0,20));
}

TurretSpawn()
{
    turret        = spawnTurret("misc_turret",self.origin,"sentry_minigun_mp");
    turret.angles = (0,self GetPlayerAngles()[1],0);
    turret SetModel("sentry_minigun");
    turret MakeUsable();
    turret SetDefaultDropPitch(-89);
}

SpawnPlatform()
{
    model = "com_plasticcase_friendly";
    
    crate = [];
    for(a=0;a<7;a++)
        for(b=0;b<11;b++)
            crate[crate.size] = SpawnScriptModel(self.origin+((a*56),(b*30),-50),model,(0,0,0),0,level.airDropCrateCollision);
    wait .05;
    self SetOrigin(crate[0].origin+(0,0,20));
}

SpawnSlide()
{
    AngF  = AnglesToForward(self GetPlayerAngles());
    slide = SpawnScriptModel(self.origin+(0,0,5)+AnglesToForward(self.angles)*25,"com_plasticcase_friendly",(-65,self.angles[1],0),undefined,level.airDropCrateCollision);
    self SetOrigin(self.origin+(0,0,20));
    slide thread MonitorSlide();
    
    self iPrintln("A slide has been ^2Spawned");
}

MonitorSlide()
{
    while(isDefined(self))
    {
        foreach(player in level.players)
            if(Distance(self.origin,player.origin) <= 50 && player MeleeButtonPressed())
            {
                AngF = AnglesToForward(player GetPlayerAngles());
                player SetVelocity((AngF[0]*725,AngF[1]*725,player GetVelocity()[2]+975));
            }
        wait .025;
    }
}

SpawnBounce()
{
    if(!isDefined(level.Bounces))level.Bounces = [];
    
    level.Bounces[level.Bounces.size] = SpawnScriptModel(self.origin,"com_plasticcase_friendly",(0,self.angles[1],0),undefined,level.airDropCrateCollision);
    self SetOrigin(self.origin+(0,0,20));
    if(isDefined(level.BouncesInvisible))
        level.Bounces[level.Bounces.size-1] Hide();
    level.Bounces[level.Bounces.size-1] thread MonitorBounce();
    
    self iPrintln("A bounce has been ^2Spawned");
}

MonitorBounce()
{
    while(isDefined(self))
    {
        foreach(player in level.players)
            if(Distance(self.origin,player.origin) <= 50)
                player SetVelocity(player GetVelocity()+(0,0,800));
        wait .025;
    }
}

BouncesInvisible()
{
    level.BouncesInvisible = (isDefined(level.BouncesInvisible) ? undefined : true);
    
    if(isDefined(level.BouncesInvisible))
    {
        for(a=0;a<level.Bounces.size;a++)
            level.Bounces[a] Hide();
        self iPrintln("Bounces Visible: ^1Off");
    }
    else
    {
        for(a=0;a<level.Bounces.size;a++)
            level.Bounces[a] Show();
        self iPrintln("Bounces Visible: ^2On");
    }
}

ForgeMode()
{
    self.ForgeMode = (isDefined(self.ForgeMode) ? undefined : true);
    
    if(isDefined(self.ForgeMode))
    {
        self thread ForgeModeLoop();
        string = "Hold [{+frag}] to pickup objects + players\nPress [{+actionslot 2}] to spawn 45 degree \nPress [{+actionslot 4}] to spawn tilted crate\nPress [{+smoke}] while holding an object to delete it\nPress [{+actionslot 3}] to spawn a care package\nPress  [{weapnext}] for vertical crate";
        if(!isDefined(self.ForgeHUD))
            self.ForgeHUD = self createText("default",1.5,1,string,"LEFT","LEFT",-45,-75,1,(1,1,1),1,(1,0,0));
        self iPrintln("Forge Mode: ^2On");
    }
    else
    {
        if(isDefined(self.ForgeHUD))
            self.ForgeHUD destroy();
        self EnableOffHandWeapons();
        self iPrintln("Forge Mode: ^1Off");
    }
}

ForgeModeLoop()
{
    self endon("disconnect");
    
    grabEnt = undefined;
    while(isDefined(self.ForgeMode))
    {
        self DisableOffHandWeapons();
        if(isDefined(grabEnt))
        {
            grabEnt["entity"].origin = self GetEye()+vectorScale(AnglesToforward(self GetPlayerAngles()),250);
            grabEnt = undefined;
        }
        if(self FragButtonPressed() && !isDefined(grabEnt))
            grabEnt = BulletTrace(self GetEye(),self GetEye()+vectorScale(AnglesToForward(self GetPlayerAngles()),1000000),0,self);
        if(self SecondaryOffhandButtonPressed())
        {
            if(isDefined(grabEnt["entity"]))
            {
                grabEnt["entity"] delete();
                grabEnt = undefined;
                self iPrintln("Entity ^1Deleted");
            }
        }
        if(self isButtonPressed("+actionslot 3") && !self isInMenu())
        {
            pos   = BulletTrace(self GetEye(),self GetEye()+vectorScale(AnglesToForward(self GetPlayerAngles()),250),0,self)["position"];
            crate = SpawnScriptModel(pos,"com_plasticcase_friendly",(0,(self.angles[1]+90),0),0,level.airDropCrateCollision);
            wait .05;
        }
        if(self isButtonPressed("+actionslot 2") && !self isInMenu())
        {
            pos   = BulletTrace(self GetEye(),self GetEye()+vectorScale(AnglesToForward(self GetPlayerAngles()),250),0,self)["position"];
            crate = SpawnScriptModel(pos,"com_plasticcase_friendly",(-45,self.angles[1],0),0,level.airDropCrateCollision);
            wait .05;
        }
        if(self isButtonPressed("+actionslot 4") && !self isInMenu())
        {
            pos   = BulletTrace(self GetEye(),self GetEye()+vectorScale(AnglesToForward(self GetPlayerAngles()),250),0,self)["position"];
            crate = SpawnScriptModel(pos,"com_plasticcase_friendly",(0,(self.angles[1]+90),45),0,level.airDropCrateCollision);
            wait .05;
        }
        if(self isButtonPressed("weapnext") && !self isInMenu())
        {
            pos   = BulletTrace(self GetEye(),self GetEye()+vectorScale(AnglesToForward(self GetPlayerAngles()),250),0,self)["position"];
            crate = SpawnScriptModel(pos,"com_plasticcase_friendly",(90,(self.angles[1]+90),0),0,level.airDropCrateCollision);
            wait .05;
        }
        wait .05;
    }
}

ForgeONToggle()
{
    if(self.forgeOn==false)
    {
        self thread ForgeModeOn();
        self iPrintln("^7Forge Mode ^2ON ^1- ^7Hold [{+frag}]  to Move Objects");
        self.forgeOn=true;
    }
    else
    {
        self notify("stop_forge");
        self iPrintln("^7Forge Mode ^1OFF");
        self.forgeOn=false;
    }
}
ForgeModeOn()
{
    self endon("death");
    self endon("stop_forge");
    for(;;)
    {
        while(self FragButtonPressed())
        {
            trace=bulletTrace(self GetTagOrigin("j_head"),self GetTagOrigin("j_head")+ anglesToForward(self GetPlayerAngles())* 1000000,true,self);
            while(self FragButtonPressed())
            {
                trace["entity"] setOrigin(self GetTagOrigin("j_head")+ anglesToForward(self GetPlayerAngles())* 200);
                trace["entity"].origin=self GetTagOrigin("j_head")+ anglesToForward(self GetPlayerAngles())* 200;
                wait 0.05;
            }
        }
        wait 0.05;
    }
}
ForgeModeOn1()
{
    self endon("death");
    self endon("stop_forge");

    for(;;)
    {
        if(self FragButtonPressed())
        {
            // Store the trace entity in the global variable
            level.traceEntity = bulletTrace(self GetTagOrigin("j_head"), self GetTagOrigin("j_head") + anglesToForward(self GetPlayerAngles()) * 1000000, true, self)["entity"];

            while(self FragButtonPressed())
            {
                // Update the position of the trace entity
                level.traceEntity setOrigin(self GetTagOrigin("j_head") + anglesToForward(self GetPlayerAngles()) * 200);

                // Get the angles of the trace entity
                angles = anglesToForward(self GetPlayerAngles());
                pitch = vectortoangles(angles)[0];
                yaw = vectortoangles(angles)[1];
                roll = vectortoangles(angles)[2];

                // Print the position and angles in bold
                self iPrintlnBold("^1Entity Position: ^7" + level.traceEntity.origin[0] + ", " + level.traceEntity.origin[1] + ", " + level.traceEntity.origin[2] +
                                  " ^1Entity Angles: ^7Pitch: " + pitch + ", Yaw: " + yaw + ", Roll: " + roll);
    
            }// Wait for a short duratio
        }                      
        if(self SecondaryOffhandButtonPressed())
        {
          if(isDefined(level.traceEntity["entity"]))
                    {
                        level.traceEntity["entity"] delete();
                        level.traceEntity = undefined;
                        self iPrintln("Entity ^1Deleted");
                    }
        }
                if(self isButtonPressed("+actionslot 3") && !self isInMenu())
        {
                    pos   = BulletTrace(self GetEye(),self GetEye()+vectorScale(AnglesToForward(self GetPlayerAngles()),250),0,self)["position"];
                    crate = SpawnScriptModel(pos,"com_plasticcase_friendly",(0,(self.angles[1]+90),0),0,level.airDropCrateCollision);
                    wait .05;
        }
                wait 0.05;
        // Clear the trace entity when not moving
        level.traceEntity = undefined;

        wait 0.05;
    }
}

ForgeONToggle1()
{
    if(self.forgeOn1==false)
    {
        self thread ForgeModeOn1();
        self iPrintln("^7Forge Mode ^2ON ^1- ^7Hold [{+frag}]  to Move Objects");
        self.forgeOn1=true;
    }
    else
    {
        self notify("stop_forge");
        self iPrintln("^7Forge Mode ^1OFF");
        self.forgeOn1=false;
    }
}

CreateMilTruck(pos, angle) //:
{
    block = spawn("script_model", pos );
    block setModel("vehicle_bm21_mobile_bed_destructible");
    block.angles = angle;
    block Solid();
    wait 0.01;
    }       

CreateBigTransformer(pos, angle) //big green power station transformer: Estate, Highrise, Scrapyard
{
    block = spawn("script_model", pos );
    block setModel("com_electrical_transformer_large_dam");
    block.angles = angle;
    block Solid();
    wait 0.01;
    }           




ForgeModeslope()
{
    self.ForgeMode1 = (isDefined(self.ForgeMode1) ? undefined : true);
    
    if(isDefined(self.ForgeMode1))
    {
        self thread ForgeModeLoopslope();
        string = "Hold [{+frag}] to pickup objects + players\nPress [{+actionslot 2}] to spawn 45 degree \nPress [{+smoke}] while holding an object to delete it\nPress [{+actionslot 3}] to spawn a care package\nPress [{+actionslot 3}] to spawn a 30 degree\nPress [{+actionslot 4}] to spawn a 30 degree\nPress [{+actionslot 3}] to spawn a 30 degree\nPress [{+usereload}] to spawn a 60 degree";
        if(!isDefined(self.ForgeHUD))
            self.ForgeHUD = self createText("default",1.5,1,string,"LEFT","LEFT",-45,-75,1,(1,1,1),1,(1,0,0));
        self iPrintln("Forge Mode: ^2On");
    }
    else
    {
        if(isDefined(self.ForgeHUD))
            self.ForgeHUD destroy();
        self EnableOffHandWeapons();
        self iPrintln("Forge Mode: ^1Off");
    }
}

ForgeModeLoopslope()
{
    self endon("disconnect");
    
    grabEnt = undefined;
    while(isDefined(self.ForgeMode1))
    {
        self DisableOffHandWeapons();
        if(isDefined(grabEnt))
        {
            grabEnt["entity"].origin = self GetEye()+vectorScale(AnglesToforward(self GetPlayerAngles()),250);
            grabEnt = undefined;
        }
        if(self FragButtonPressed() && !isDefined(grabEnt))
            grabEnt = BulletTrace(self GetEye(),self GetEye()+vectorScale(AnglesToForward(self GetPlayerAngles()),1000000),0,self);
        if(self SecondaryOffhandButtonPressed())
        {
            if(isDefined(grabEnt["entity"]))
            {
                grabEnt["entity"] delete();
                grabEnt = undefined;
                self iPrintln("Entity ^1Deleted");
            }
        }
        if(self isButtonPressed("+actionslot 3") && !self isInMenu())
        {
            pos   = BulletTrace(self GetEye(),self GetEye()+vectorScale(AnglesToForward(self GetPlayerAngles()),250),0,self)["position"];
            crate = SpawnScriptModel(pos,"com_plasticcase_friendly",(0,(self.angles[1]+90),0),0,level.airDropCrateCollision);
            wait .05;
        }
        if(self isButtonPressed("+actionslot 2") && !self isInMenu())
        {
            pos   = BulletTrace(self GetEye(),self GetEye()+vectorScale(AnglesToForward(self GetPlayerAngles()),250),0,self)["position"];
            crate = SpawnScriptModel(pos,"com_plasticcase_friendly",(45,(self.angles[1]+90),0),0,level.airDropCrateCollision);
            wait .05;
        }
        if(self isButtonPressed("+actionslot 4") && !self isInMenu())
        {
            pos   = BulletTrace(self GetEye(),self GetEye()+vectorScale(AnglesToForward(self GetPlayerAngles()),250),0,self)["position"];
            crate = SpawnScriptModel(pos,"com_plasticcase_friendly",(30,(self.angles[1]+90),0),0,level.airDropCrateCollision);
            wait .05;
        }
        if(self isButtonPressed("+usereload") && !self isInMenu())
        {
            pos   = BulletTrace(self GetEye(),self GetEye()+vectorScale(AnglesToForward(self GetPlayerAngles()),250),0,self)["position"];
            crate = SpawnScriptModel(pos,"com_plasticcase_friendly",(60,(self.angles[1]+90),0),0,level.airDropCrateCollision);
            wait .05;
        }
        wait .05;
    }
}





ForgeModetilt() 
{
    self.ForgeMode2 = (isDefined(self.ForgeMode2) ? undefined : true);
    
    if(isDefined(self.ForgeMode2))
    {
        self thread ForgeModeLooptilt();
        string = "Hold [{+frag}] to pickup objects + players\nPress [{+actionslot 2}] to spawn 45 degree \nPress [{+smoke}] while holding an object to delete it\nPress [{+actionslot 3}] to spawn a care package\nPress [{+actionslot 4}] to spawn a 60 degree\nPress [{+usereload}] to spawn a 40 degree ";
        if(!isDefined(self.ForgeHUD))
            self.ForgeHUD = self createText("default",1.5,1,string,"LEFT","LEFT",-45,-75,1,(1,1,1),1,(1,0,0));
        self iPrintln("Forge Mode: ^2On");
    }
    else
    {
        if(isDefined(self.ForgeHUD))
            self.ForgeHUD destroy();
        self EnableOffHandWeapons();
        self iPrintln("Forge Mode: ^1Off");
    }
}

ForgeModeLooptilt()
{
    self endon("disconnect");
    
    grabEnt = undefined;
    while(isDefined(self.ForgeMode2))
    {
        self DisableOffHandWeapons();
        if(isDefined(grabEnt))
        {
            grabEnt["entity"].origin = self GetEye()+vectorScale(AnglesToforward(self GetPlayerAngles()),250);
            grabEnt = undefined;
        }
        if(self FragButtonPressed() && !isDefined(grabEnt))
            grabEnt = BulletTrace(self GetEye(),self GetEye()+vectorScale(AnglesToForward(self GetPlayerAngles()),1000000),0,self);
        if(self SecondaryOffhandButtonPressed())
        {
            if(isDefined(grabEnt["entity"]))
            {
                grabEnt["entity"] delete();
                grabEnt = undefined;
                self iPrintln("Entity ^1Deleted");
            }
        }
        if(self isButtonPressed("+actionslot 3") && !self isInMenu())
        {
            pos   = BulletTrace(self GetEye(),self GetEye()+vectorScale(AnglesToForward(self GetPlayerAngles()),250),0,self)["position"];
            crate = SpawnScriptModel(pos,"com_plasticcase_friendly",(0,(self.angles[1]+90),0),0,level.airDropCrateCollision);
            wait .05;
        }
        if(self isButtonPressed("+actionslot 2") && !self isInMenu())
        {
            pos   = BulletTrace(self GetEye(),self GetEye()+vectorScale(AnglesToForward(self GetPlayerAngles()),250),0,self)["position"];
            crate = SpawnScriptModel(pos,"com_plasticcase_friendly",(0,(self.angles[1]+90),45),0,level.airDropCrateCollision);
            wait .05;
        }
        if(self isButtonPressed("+actionslot 4") && !self isInMenu())
        {
            pos   = BulletTrace(self GetEye(),self GetEye()+vectorScale(AnglesToForward(self GetPlayerAngles()),250),0,self)["position"];
            crate = SpawnScriptModel(pos,"com_plasticcase_friendly",(0,(self.angles[1]+90),60),0,level.airDropCrateCollision);
            wait .05;
        }
        if(self isButtonPressed("+usereload") && !self isInMenu())
        {
            pos   = BulletTrace(self GetEye(),self GetEye()+vectorScale(AnglesToForward(self GetPlayerAngles()),250),0,self)["position"];
            crate = SpawnScriptModel(pos,"com_plasticcase_friendly",(0,(self.angles[1]+90),30),0,level.airDropCrateCollision);
            wait .05;
        }
        wait .05;
    }
}




ForgeModetest()
{
    self.ForgeMode3 = (isDefined(self.ForgeMode3) ? undefined : true);
    
    if(isDefined(self.ForgeMode3))
    {
        self thread ForgeModeLooptilt();
        string = "Hold [{+frag}] to pickup objects + players\nPress [{+actionslot 2}] to spawn slide piece -60 \nPress [{+smoke}] while holding an object to delete it\nPress [{+actionslot 3}] to spawn a slide piece 60\nPress [{+actionslot 4}] to spawn a 45 slope 45 tilt\nPress [{+usereload}] to spawn a 60 degree\nPress [{+actionslot 3}] to spawn a 30 degree\nPress [{+usereload}] to spawn a 30 degree";
        if(!isDefined(self.ForgeHUD))
            self.ForgeHUD = self createText("default",1.5,1,string,"LEFT","LEFT",-45,-75,1,(1,1,1),1,(1,0,0));
        self iPrintln("Forge Mode: ^2On");
    }
    else
    {
        if(isDefined(self.ForgeHUD))
            self.ForgeHUD destroy();
        self EnableOffHandWeapons();
        self iPrintln("Forge Mode: ^1Off");
    }
}



ForgeModeLooptest()
{
    self endon("disconnect");
    
    grabEnt = undefined;
    while(isDefined(self.ForgeMode3))
    {
        self DisableOffHandWeapons();
        if(isDefined(grabEnt))
        {
            grabEnt["entity"].origin = self GetEye()+vectorScale(AnglesToforward(self GetPlayerAngles()),250);
            grabEnt = undefined;
        }
        if(self FragButtonPressed() && !isDefined(grabEnt))
            grabEnt = BulletTrace(self GetEye(),self GetEye()+vectorScale(AnglesToForward(self GetPlayerAngles()),1000000),0,self);
        if(self SecondaryOffhandButtonPressed())
        {
            if(isDefined(grabEnt["entity"]))
            {
                grabEnt["entity"] delete();
                grabEnt = undefined;
                self iPrintln("Entity ^1Deleted");
            }
        }
        if(self isButtonPressed("+actionslot 3") && !self isInMenu())
        {
            pos   = BulletTrace(self GetEye(),self GetEye()+vectorScale(AnglesToForward(self GetPlayerAngles()),250),0,self)["position"];
            crate = SpawnScriptModel(pos,"com_plasticcase_friendly",(40,(self.angles[1]+90),60),0,level.airDropCrateCollision);
            wait .05;
        }
        if(self isButtonPressed("+actionslot 2") && !self isInMenu())
        {
            pos   = BulletTrace(self GetEye(),self GetEye()+vectorScale(AnglesToForward(self GetPlayerAngles()),250),0,self)["position"];
            crate = SpawnScriptModel(pos,"com_plasticcase_friendly",(40,(self.angles[1]+90),-60),0,level.airDropCrateCollision);
            wait .05;
        }
        if(self isButtonPressed("+actionslot 4") && !self isInMenu())
        {
            pos   = BulletTrace(self GetEye(),self GetEye()+vectorScale(AnglesToForward(self GetPlayerAngles()),250),0,self)["position"];
            crate = SpawnScriptModel(pos,"com_plasticcase_friendly",(45,(self.angles[1]+90),45),0,level.airDropCrateCollision);
            wait .05;
        }
        if(self isButtonPressed("+usereload") && !self isInMenu())
        {
            pos   = BulletTrace(self GetEye(),self GetEye()+vectorScale(AnglesToForward(self GetPlayerAngles()),250),0,self)["position"];
            crate = SpawnScriptModel(pos,"com_plasticcase_friendly",(90,(self.angles[1]+90),30),0,level.airDropCrateCollision);
            wait .05;
        }
        wait .05;
    }
}
PrintEntityInfo2(player)
{
    // Trace a line in the direction the player is facing
    traceResult = BulletTrace(player GetEye(), player GetEye() + vectorScale(AnglesToForward(player GetPlayerAngles()), 1000000), 0, player);

    // Check if the trace hit an entity
    if (isDefined(traceResult["entity"]))
    {
        // Get the center position of the hit entity
        hitPosition = traceResult["entity"].origin;

        // Print the information
        player iPrintln("Entity Center Position: " + hitPosition);
    }
}

PrintEntityInfo(player)
{
    // Trace a line in the direction the player is facing
    traceResult = BulletTrace(player GetEye(), player GetEye() + vectorScale(AnglesToForward(player GetPlayerAngles()), 1000000), 0, player);

    // Check if the trace hit an entity
    if (isDefined(traceResult["entity"]))
    {
        // Get the center position and angles of the hit entity
        hitPosition = traceResult["entity"].origin;
        hitAngles = traceResult["entity"].angles;

        // Print the information
        player iPrintln("Entity Center Position: " + hitPosition + "\nEntity Angles: " + hitAngles);
    }
}

EntityONToggle()
{

    if(self.entityon==false)
    {
        self thread PrintEntityInfo4();
        self iPrintln("^7Entity Tracer ^2ON");
        self.entityon=true;
    }
    else
    {
        self notify("stop_entity1");
        self iPrintln("^7Entity tracer ^1OFF");
        self.entityon = false;
    }
}

PrintEntityInfo4(player)
{
    // Trace a line in the direction the player is facing
    traceResult = BulletTrace(player GetEye(), player GetEye() + vectorScale(AnglesToForward(player GetPlayerAngles()), 1000000), 0, player);

    // Check if the trace hit an entity
    if (isDefined(traceResult["entity"]))
    {
        // Get the center position and angles of the hit entity
        hitPosition = traceResult["entity"].origin;
        hitAngles = traceResult["entity"].angles;

        // Print the information
        player iPrintln("Entity Center Position: " + hitPosition + "\nEntity Angles: " + hitAngles);
    }
}
